<?php
/*
 * Copyright (c)  2009, Tracmor, LLC
 *
 * This file is part of Tracmor.
 *
 * Tracmor is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Tracmor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Tracmor; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

require_once('../includes/prepend.inc.php');
QApplication::Authenticate(2);
require_once(__FORMBASE_CLASSES__ . '/AssetModelEditFormBase.class.php');

/**
 * This is a quick-and-dirty draft form object to do Create, Edit, and Delete functionality
 * of the AssetModel class.  It extends from the code-generated
 * abstract AssetModelEditFormBase class.
 *
 * Any display custimizations and presentation-tier logic can be implemented
 * here by overriding existing or implementing new methods, properties and variables.
 *
 * Additional qform control objects can also be defined and used here, as well.
 *
 * @package Application
 * @subpackage FormDraftObjects
 *
 */
class AssetModelEditForm extends AssetModelEditFormBase {

	// Header Tabs
	protected $ctlHeaderMenu;
	// Shortcut Menu
	protected $ctlShortcutMenu;

	protected $lblShortDescription;
	protected $lblAssetModelHeader;
	protected $lblAssetModelCode;
	protected $lblCategory;
	protected $lblManufacturer;
	protected $lblDepreciationClass;
	protected $btnEdit;
	protected $ifcImage;
	protected $lblImage;
	protected $pnlLongDescription;

	protected $lstDepreciationClass;

	protected $atcAttach;
	protected $pnlAttachments;

  // Set Asset Custom Fields checkbox list
  protected $chkAssetCustomFields;

	// Set checkbox list for all Asset Model
	protected  $chkCustomFieldsForAllModels;

	// Custom Field Objects
	public $arrCustomFields;

	// Set true if the Built-in Fields have to be rendered
	public $blnViewBuiltInFields;
	public $blnEditBuiltInFields;

	// Generate tab indexes
	protected $intNextTabIndex = 1;

	protected function Form_Create() {

		// Call SetupAssetModel to either Load/Edit Existing or Create New
		$this->SetupAssetModel();

		// Create the Header Menu
		$this->ctlHeaderMenu_Create();
		// Create the Shortcut Menu
		$this->ctlShortcutMenu_Create();

		// Create labels and buttons not included in generated form
		$this->lblShortDescription_Create();
		$this->lblAssetModelCode_Create();
		$this->lblAssetModelHeader_Create();
		$this->lblCategory_Create();
		$this->lblManufacturer_Create();
		$this->txtShortDescription_Create();
		$this->lstCategory_Create();
		$this->txtLongDescription_Create();
		$this->txtAssetModelCode_Create();
		$this->lstManufacturer_Create();
		$this->txtImagePath_Create();
		$this->ifcImage_Create();
		// Image label must be created AFTER image control
		$this->lblImage_Create();
		$this->pnlLongDescription_Create();


		if (QApplication::$TracmorSettings->DepreciationFlag == '1'){
			$this->lblDepreciationClass_Create();
			$this->lstDepreciationClass_Create();
		}

		// Set a variable which defines whether the built-in fields must be rendered or not.
		$this->UpdateBuiltInFields();

		// Create all custom asset fields
		$this->customFields_Create();

        // Create Asset Custom Fields multi-select checkbox;
        $this->chkAssetCustomFields_Create();

		// Create checkbox_list
		$this->chkCustomFieldsForAll_Create();

		// Create/Setup Button Action controls
		$this->btnEdit_Create();
		$this->btnSave_Create();
		$this->btnCancel_Create();
		$this->btnDelete_Create();
		$this->atcAttach_Create();
		$this->pnlAttachments_Create();

		// $this->btnClone_Create();

		// Display labels for the existing asset
		if ($this->blnEditMode) {
			$this->displayLabels();
		}
		// Display empty inputs to create a new asset
		else {
			$this->displayInputs();
		}

		// Output the database profile - for debugging purposes only
		// QApplication::$Database[1]->OutputProfiling();

	}

	protected function SetupAssetModel() {
		parent::SetupAssetModel();
		QApplication::AuthorizeEntity($this->objAssetModel, $this->blnEditMode);
	}

	// Create and Setup the Header Composite Control
	protected function ctlHeaderMenu_Create() {
		$this->ctlHeaderMenu = new QHeaderMenu($this);
	}

	// Create and Setp the Shortcut Menu Composite Control
	protected function ctlShortcutMenu_Create() {
		$this->ctlShortcutMenu = new QShortcutMenu($this);
	}

	// Create the Short Description label (Asset Model Name)
	protected function lblShortDescription_Create() {
		$this->lblShortDescription = new QLabel($this);
		$this->lblShortDescription->Name = 'Model';
		if ($this->blnEditMode) {
			$this->lblShortDescription->Text = $this->objAssetModel->__toString();
		}
	}

	// Create the Asset Model Header label (Asset Model Name)
	protected function lblAssetModelHeader_Create() {
		$this->lblAssetModelHeader = new QLabel($this);
		$this->lblAssetModelHeader->Name = 'Model';
		if(!$this->blnEditMode){
			$this->lblAssetModelHeader->Text = "New Model";
		}else{
			$this->lblAssetModelHeader->Text = $this->objAssetModel->__toString();
		}
	}

	// Create the Asset Model Code label
	protected function lblAssetModelCode_Create() {
		// It is better to use late-binding here because we are only getting one record
		$this->lblAssetModelCode = new QLabel($this);
		$this->lblAssetModelCode->Name = 'Model Number';
		if ($this->blnEditMode) {
			$this->lblAssetModelCode->Text = $this->objAssetModel->AssetModelCode;
		}
	}

	// Create the Category Label
	protected function lblCategory_Create() {
		$this->lblCategory = new QLabel($this);
		$this->lblCategory->Name = 'Category';
		if ($this->blnEditMode) {
			$this->lblCategory->Text = $this->objAssetModel->Category->ShortDescription;
		}
	}

	// Create the Manufacturer Label
	protected function lblManufacturer_Create() {
		$this->lblManufacturer = new QLabel($this);
		$this->lblManufacturer->Name = 'Manufacturer';
		if ($this->blnEditMode) {
			$this->lblManufacturer->Text = $this->objAssetModel->Manufacturer->ShortDescription;
		}
	}

	// Create the Depreciation Class Label
	protected function lblDepreciationClass_Create(){
		$this->lblDepreciationClass = new QLabel($this);
		$this->lblDepreciationClass->Name = 'Depreciation Class';

		if($this->blnEditMode){
			if($this->objAssetModel->DepreciationClassId == null){
			$this->lblDepreciationClass->Text = '';
			}
			else{
			$this->lblDepreciationClass->Text = $this->objAssetModel->DepreciationClass->ShortDescription;
			}
		}

	}

	// Output the image
	protected function lblImage_Create() {
		$this->lblImage = new QLabel($this);
		$this->lblImage->Text = $this->ifcImage->GetDisplayHtml($this->objAssetModel->ImagePath);
		$this->lblImage->HtmlEntities = false;
	}

	// Create the Long Description Panel
	protected function pnlLongDescription_Create() {
		$this->pnlLongDescription = new QPanel($this);
		$this->pnlLongDescription->CssClass='scrollBox';
		if ($this->blnEditMode) {
			$this->pnlLongDescription->Text= nl2br($this->objAssetModel->LongDescription);
		}
	}

	// Create the Image File Control
	protected function ifcImage_Create() {
		$this->ifcImage = new QImageFileControl($this);
		// $this->ifcImage->UploadPath = "/www/imagestorage/";
		$this->ifcImage->UploadPath = "../images/asset_models/";
		$this->ifcImage->WebPath = "../images/asset_models/";
		$this->ifcImage->ThumbUploadPath = "../images/asset_models/thumbs/";
		$this->ifcImage->ThumbWebPath = "../images/asset_models/thumbs/";
		// $this->ifcImage->FileName = $this->objAssetModel->ImagePath;
		$this->ifcImage->Name = 'Upload Picture';
		$this->ifcImage->BuildThumbs = true;
		$this->ifcImage->ThumbWidth = 150;
		$this->ifcImage->ThumbHeight = 250;
		$this->ifcImage->Required = false;
		// $this->ifcImage->ThumbPrefix = "thumb_";
		$this->ifcImage->Prefix = QApplication::$TracmorSettings->ImageUploadPrefix;
		$this->ifcImage->Suffix = "_asset_model";
		$this->ifcImage->TabIndex=6;
		$this->intNextTabIndex++;
	}

	// Create and Setup txtShortDescription
	protected function txtShortDescription_Create() {
		parent::txtShortDescription_Create();
		$this->txtShortDescription->CausesValidation = true;
		$this->txtShortDescription->AddAction(new QEnterKeyEvent(), new QServerAction('btnSave_Click'));
		$this->txtShortDescription->AddAction(new QEnterKeyEvent(), new QTerminateAction());
		$this->txtShortDescription->TabIndex=1;
		$this->intNextTabIndex++;
		QApplication::ExecuteJavaScript(sprintf("document.getElementById('%s').focus()", $this->txtShortDescription->ControlId));
	}

	// Create and Setup txtAssetModelCode
	protected function txtAssetModelCode_Create() {
		parent::txtAssetModelCode_Create();
		$this->txtAssetModelCode->Required = true;
		$this->txtAssetModelCode->CausesValidation = true;
		$this->txtAssetModelCode->AddAction(new QEnterKeyEvent(), new QServerAction('btnSave_Click'));
		$this->txtAssetModelCode->AddAction(new QEnterKeyEvent(), new QTerminateAction());
		$this->txtAssetModelCode->TabIndex=4;
		$this->intNextTabIndex++;
	}

	// Create and Setup txtLongDescription
	protected function txtLongDescription_Create() {
		parent::txtLongDescription_Create();
		$this->txtLongDescription->TabIndex=5;
		$this->intNextTabIndex++;
	}

	// Create and Setup lstCategory
	protected function lstCategory_Create() {
		$this->lstCategory = new QListBox($this);
		$this->lstCategory->Name = QApplication::Translate('Category');
		$this->lstCategory->Required = true;
		if (!$this->blnEditMode)
		$this->lstCategory->AddItem('- Select One -', null);
		$objCategoryArray = Category::LoadAllWithFlags(true, false, 'short_description ASC');
		if ($objCategoryArray) foreach ($objCategoryArray as $objCategory) {
			$objListItem = new QListItem($objCategory->__toString(), $objCategory->CategoryId);
			if (($this->objAssetModel->Category) && ($this->objAssetModel->Category->CategoryId == $objCategory->CategoryId))
			$objListItem->Selected = true;
			$this->lstCategory->AddItem($objListItem);
		}
		$this->lstCategory->TabIndex=2;
		$this->intNextTabIndex++;
	}

	// Create and Setup lstManufacturer
	protected function lstManufacturer_Create() {
		$this->lstManufacturer = new QListBox($this);
		$this->lstManufacturer->Name = QApplication::Translate('Manufacturer');
		$this->lstManufacturer->Required = true;
		if (!$this->blnEditMode)
		{
			$this->lstManufacturer->AddItem('- Select One -', null);
		}
		// $objManufacturerArray = Manufacturer::LoadAll('short_description ASC');
		$objManufacturerArray = Manufacturer::LoadAll(QQ::Clause(QQ::OrderBy(QQN::Manufacturer()->ShortDescription)));
		if ($objManufacturerArray) foreach ($objManufacturerArray as $objManufacturer) {
			$objListItem = new QListItem($objManufacturer->__toString(), $objManufacturer->ManufacturerId);
			if (($this->objAssetModel->Manufacturer) && ($this->objAssetModel->Manufacturer->ManufacturerId == $objManufacturer->ManufacturerId))
			$objListItem->Selected = true;
			$this->lstManufacturer->AddItem($objListItem);
		}
		$this->lstManufacturer->TabIndex=3;
		$this->intNextTabIndex++;
	}

	// Create all Custom Asset Fields
	protected function customFields_Create() {

		// Load all custom fields and their values into an array objCustomFieldArray->CustomFieldSelection->CustomFieldValue
		$this->objAssetModel->objCustomFieldArray = CustomField::LoadObjCustomFieldArray(4, $this->blnEditMode, $this->objAssetModel->AssetModelId);

		// Create the Custom Field Controls - labels and inputs (text or list) for each
		$this->arrCustomFields = CustomField::CustomFieldControlsCreate($this->objAssetModel->objCustomFieldArray, $this->blnEditMode, $this, true, true);

		$this->UpdateCustomFields();
	}

	// Create Depreciation Class select

	protected function lstDepreciationClass_Create(){
		$this->lstDepreciationClass = new QListBox($this);
		$this->lstDepreciationClass->Name = QApplication::Translate('Depreciation Class');
		//if (!$this->blnEditMode)
			$this->lstDepreciationClass->AddItem('- Select One -', null);
		$objDepreciationClassArray = DepreciationClass::LoadAll();

		if (is_array($objDepreciationClassArray)) {
			foreach ($objDepreciationClassArray as $objDepreciationClass) {
				$objListItem = new QListItem($objDepreciationClass->ShortDescription, $objDepreciationClass->DepreciationClassId);
				if (($this->objAssetModel->DepreciationClass) && ($this->objAssetModel->DepreciationClass->DepreciationClassId == $objDepreciationClass->DepreciationClassId))
					$objListItem->Selected = true;
				$this->lstDepreciationClass->AddItem($objListItem);
			}
		}
	}

	// Setup Save Button
	protected function btnSave_Create() {
		$this->btnSave = new QButton($this);
		$this->btnSave->Text = 'Save';
		$this->btnSave->CausesValidation = true;
		// This cannot be Ajax because Javascript cannot access local files
		$this->btnSave->AddAction(new QClickEvent(), new QServerAction('btnSave_Click'));
		$this->btnSave->AddAction(new QEnterKeyEvent(), new QServerAction('btnSave_Click'));
		$this->btnSave->AddAction(new QEnterKeyEvent(), new QTerminateAction());
		$this->btnSave->TabIndex= $this->intNextTabIndex++;

	}

	// Setup Cancel Button
	protected function btnCancel_Create() {
		$this->btnCancel = new QButton($this);
		$this->btnCancel->Text = 'Cancel';
		$this->btnCancel->AddAction(new QClickEvent(), new QAjaxAction('btnCancel_Click'));
		$this->btnCancel->CausesValidation = false;
		$this->btnCancel->TabIndex = $this->intNextTabIndex++;
	}

	// Setup Edit Button
	protected function btnEdit_Create() {
		$this->btnEdit = new QButton($this);
		$this->btnEdit->Text = 'Edit';
		$this->btnEdit->AddAction(new QClickEvent(), new QAjaxAction('btnEdit_Click'));
		$this->btnEdit->CausesValidation = false;
		QApplication::AuthorizeControl($this->objAssetModel, $this->btnEdit, 2);
	}

	// Setup Delete Button
	protected function btnDelete_Create() {
		$this->btnDelete = new QButton($this);
		$this->btnDelete->Text = 'Delete';
		$this->btnDelete->AddAction(new QClickEvent(), new QConfirmAction('Are you SURE you want to DELETE this Model?'));
		$this->btnDelete->AddAction(new QClickEvent(), new QServerAction('btnDelete_Click'));
		$this->btnDelete->CausesValidation = false;
		if (!$this->blnEditMode) {
			$this->btnDelete->Display = false;
		}
		QApplication::AuthorizeControl($this->objAssetModel, $this->btnDelete, 3);
	}


	// Setup Attach File Asset Button
	protected function atcAttach_Create() {
		$this->atcAttach = new QAttach($this, null, EntityQtype::AssetModel, $this->objAssetModel->AssetModelId);
		QApplication::AuthorizeControl($this->objAssetModel, $this->atcAttach, 2);
	}

	// Setup Attachments Panel
	public function pnlAttachments_Create() {
		$this->pnlAttachments = new QAttachments($this, null, EntityQtype::AssetModel, $this->objAssetModel->AssetModelId);
	}

	// Setup Asset Custom Fields multi-select check box
	protected function chkAssetCustomFields_Create(){
	$this->chkAssetCustomFields = new QCheckBoxList($this);
	$this->chkAssetCustomFields->Name = 'Asset Custom Fields:';
	$this->chkAssetCustomFields_Refresh();
	}

	// Setup Asset Custom Fields multi-select check box
	protected function chkCustomFieldsForAll_Create(){
		$this->chkCustomFieldsForAllModels = new QCheckBoxList($this);
		$this->chkCustomFieldsForAllModels->Name = 'Asset Custom Fields for all Models:';
		$arrAssetCustomFieldOptions = EntityQtypeCustomField::LoadArrayByEntityQtypeId(
			                                                      QApplication::Translate(EntityQtype::Asset));
		if(count($arrAssetCustomFieldOptions)>0){
			if ($this->blnEditMode){
				$arrChosenCustomFieldId = array();
				$arrChosenCustomField = AssetCustomFieldAssetModel::LoadArrayByAssetModelId($this->objAssetModel->AssetModelId);
				foreach ($arrChosenCustomField as $objChosenCustomField){
					$arrChosenCustomFieldId[] = $objChosenCustomField->CustomFieldId;
				}
			}
			foreach($arrAssetCustomFieldOptions as $arrAssetCustomFieldOption){
				$selected = false;
				if($this->blnEditMode){
					$selected = in_array($arrAssetCustomFieldOption->CustomField->CustomFieldId,$arrChosenCustomFieldId);
				}
				$role=RoleEntityQtypeCustomFieldAuthorization::LoadByRoleIdEntityQtypeCustomFieldIdAuthorizationId(
					QApplication::$objRoleModule->RoleId,
					$arrAssetCustomFieldOption->EntityQtypeCustomFieldId,
					2
				);
				if($role instanceof RoleEntityQtypeCustomFieldAuthorization){
					$role = $role->AuthorizedFlag;
				}
				if($arrAssetCustomFieldOption->CustomField->AllAssetModelsFlag
					&&$arrAssetCustomFieldOption->CustomField->ActiveFlag
					&& (int)$role==1
				){
					$this->chkCustomFieldsForAllModels->AddItem(new QListItem($arrAssetCustomFieldOption->CustomField->ShortDescription,
						$arrAssetCustomFieldOption->CustomField->CustomFieldId,
						true
					));
				}
			}
		}
		$this->chkCustomFieldsForAllModels->Enabled = false;
	}

	protected function chkAssetCustomFields_Refresh(){
		$arrAssetCustomFieldOptions = EntityQtypeCustomField::LoadArrayByEntityQtypeId(QApplication::Translate(EntityQtype::Asset));
		if(count($arrAssetCustomFieldOptions)>0){
			if ($this->blnEditMode){
				$arrChosenCustomFieldId = array();
				$arrChosenCustomField = AssetCustomFieldAssetModel::LoadArrayByAssetModelId($this->objAssetModel->AssetModelId);
				foreach ($arrChosenCustomField as $objChosenCustomField){
					$arrChosenCustomFieldId[] = $objChosenCustomField->CustomFieldId;
				}
			}
			foreach($arrAssetCustomFieldOptions as $arrAssetCustomFieldOption){
				$selected = false;
				if($this->blnEditMode){
					$selected = in_array($arrAssetCustomFieldOption->CustomField->CustomFieldId,$arrChosenCustomFieldId);
				}
				/*     else{
	   $selected = $arrAssetCustomFieldOption->CustomField->AllAssetModelsFlag;
	 }
*///Excluding AllAssetModelsFlaged Items just until setup qcodo 4.22
				$role=RoleEntityQtypeCustomFieldAuthorization::LoadByRoleIdEntityQtypeCustomFieldIdAuthorizationId(
					QApplication::$objRoleModule->RoleId,
					$arrAssetCustomFieldOption->EntityQtypeCustomFieldId,
					2
				);
				if($role instanceof RoleEntityQtypeCustomFieldAuthorization){
					$role = $role->AuthorizedFlag;
				}
				if(!$arrAssetCustomFieldOption->CustomField->AllAssetModelsFlag
					&&$arrAssetCustomFieldOption->CustomField->ActiveFlag
					&& (int)$role==1
				){
					$this->chkAssetCustomFields->AddItem(new QListItem($arrAssetCustomFieldOption->CustomField->ShortDescription,
						$arrAssetCustomFieldOption->CustomField->CustomFieldId,
						$selected
					));
				}
			}
		}
		if ($this->chkAssetCustomFields->ItemCount==0){
			$this->chkAssetCustomFields->Display = false;
		}
		if($this->blnEditMode) {
			$this->chkAssetCustomFields->Enabled = false;
		}
	}
	// Edit Button Click
	protected function btnEdit_Click($strFormId, $strControlId, $strParameter) {

		$this->displayInputs();
        $this->chkAssetCustomFields->Enabled = true;
		$this->UpdateBuiltInFields();
		$this->UpdateCustomFields();
	}

	// Save Button Click Actions
	protected function btnSave_Click($strFormId, $strControlId, $strParameter) {
		
		$blnError = false;
			
		if (trim($this->txtShortDescription->Text) == "") {
			$this->txtShortDescription->Warning = 'Short description is required';
			$blnError = true;
		}

		if (trim($this->txtAssetModelCode->Text) == "") {
			$this->txtAssetModelCode->Warning = 'Model number is required';
			$blnError = true;
		}

		if ($blnError) {
			return;
		}

		if(QApplication::$TracmorSettings->DepreciationFlag =='1'&& $this->blnEditMode){
			if($this->objAssetModel->DepreciationClassId != $this->lstDepreciationClass->SelectedValue){
				$arrAssetToChange =	Asset::LoadArrayDepreciatedByAssetModelId($this->objAssetModel->AssetModelId);
				if($this->lstDepreciationClass->SelectedValue == null){
					foreach($arrAssetToChange as $objAssetToChange){
						$objAssetToChange->DepreciationFlag = null;
						$objAssetToChange->PurchaseCost = null;
						$objAssetToChange->PurchaseDate= null;
						$objAssetToChange->Save();
					}
				}
			}
		}

    $this->UpdateAssetModelFields();
		$this->objAssetModel->Save();
        $this->UpdateAssetModelCustomFields();
		// Assign input values to custom fields
		if ($this->arrCustomFields) {

			// Save the values from all of the custom field controls to save the asset
			CustomField::SaveControls($this->objAssetModel->objCustomFieldArray, $this->blnEditMode, $this->arrCustomFields, $this->objAssetModel->AssetModelId, 4);
		}

		if ($this->ifcImage->FileName) {
			// Retrieve the extension (.jpg, .gif) from the filename
			$explosion = explode(".", $this->ifcImage->FileName);
			// Set the file name to ID_asset_model.ext
			$this->ifcImage->FileName = sprintf('%s%s%s.%s', $this->ifcImage->Prefix, $this->objAssetModel->AssetModelId, $this->ifcImage->Suffix, $explosion[1]);
			// Set the image path for saving the asset model
			$this->txtImagePath->Text = $this->ifcImage->FileName;
			// Upload the file to the server
			$this->ifcImage->ProcessUpload();

			// Save the image path information to the AssetModel object
			$this->objAssetModel->ImagePath = $this->txtImagePath->Text;
			$this->objAssetModel->Save(false, true);
		}

    	if ($this->blnEditMode) {
			$this->UpdateLabels();
			// This was necessary because it was not saving the changes of a second edit/save in a row
			// Reload all custom fields
			$this->objAssetModel->objCustomFieldArray = CustomField::LoadObjCustomFieldArray(4, $this->blnEditMode, $this->objAssetModel->AssetModelId);
			$this->displayLabels();
            $this->chkAssetCustomFields->Enabled = false;
		}
		else {
			// Display the asset model list page
			$strRedirect = "asset_model_list.php";
			QApplication::Redirect($strRedirect);
		}
	}

	// Cancel Button Click Actions
	protected function btnCancel_Click($strFormId, $strControlId, $strParameter) {
		if ($this->blnEditMode) {
			$this->displayLabels();
			$this->UpdateAssetModelControls();
			if ($this->chkAssetCustomFields->CountItems()>0){
				$this->chkAssetCustomFields->RemoveAllItems();
				$this->chkAssetCustomFields_Refresh();
				$this->chkAssetCustomFields->Enabled = false;
			}
		}
		else {
			QApplication::Redirect('asset_model_list.php');
		}
	}

	// Delete Button Click Actions - Erase Image and erase entry
	protected function btnDelete_Click($strFormId, $strControlId, $strParameter) {
		$this->ifcImage->Delete($this->objAssetModel->ImagePath);

		try {
			// Get an instance of the database
			$objDatabase = QApplication::$Database[1];
			// Begin a MySQL Transaction to be either committed or rolled back
			$objDatabase->TransactionBegin();
			$strImagePath = $this->objAssetModel->ImagePath;
			$objCustomFieldArray = $this->objAssetModel->objCustomFieldArray;
			$this->objAssetModel->Delete();
			$this->ifcImage->Delete($strImagePath);
			// Custom Field Values for text fields must be manually deleted because MySQL ON DELETE will not cascade to them
			// The values should not get deleted for select values
			// CustomField::DeleteTextValues($objCustomFieldArray);
			$objDatabase->TransactionCommit();
			$this->RedirectToListPage();
		}
		catch (QDatabaseExceptionBase $objExc) {
			$objDatabase->TransactionRollback();
			if ($objExc->ErrorNumber == 1451) {
				$this->btnDelete->Warning = 'This model cannot be deleted because it is associated with one or more assets.';
			}
			else {
				throw new QDatabaseExceptionBase();
			}
		}
	}

	// Protected Update Methods
	protected function UpdateAssetModelFields() {
		$this->objAssetModel->CategoryId = $this->lstCategory->SelectedValue;
		$this->objAssetModel->ManufacturerId = $this->lstManufacturer->SelectedValue;
		$this->objAssetModel->AssetModelCode = $this->txtAssetModelCode->Text;
		$this->objAssetModel->ShortDescription = $this->txtShortDescription->Text;
		$this->objAssetModel->LongDescription = $this->txtLongDescription->Text;
		// Display Depreciation field if enabled
		if (QApplication::$TracmorSettings->DepreciationFlag == '1'){
			$this->objAssetModel->DepreciationClassId = $this->lstDepreciationClass->SelectedValue;
		}
		// $this->objAssetModel->ImagePath = $this->txtImagePath->Text;
	}

	// Assign the original values to all Asset Controls
	protected function UpdateAssetModelControls() {

		$this->lstCategory->SelectedValue = $this->objAssetModel->CategoryId;
		$this->lstManufacturer->SelectedValue = $this->objAssetModel->ManufacturerId;
		$this->txtAssetModelCode->Text = $this->objAssetModel->AssetModelCode;
		$this->txtShortDescription->Text = $this->objAssetModel->ShortDescription;
		$this->txtLongDescription->Text = $this->objAssetModel->LongDescription;
		$this->txtImagePath->Text = $this->objAssetModel->ImagePath;
		$this->arrCustomFields = CustomField::UpdateControls($this->objAssetModel->objCustomFieldArray, $this->arrCustomFields);
	}

	// Display the labels and buttons for Asset Model Viewing mode
	protected function displayLabels() {

		$this->lblImage->Display = true;
		$this->ifcImage->Display = false;

		// Do not display inputs
		$this->txtShortDescription->Display = false;
		$this->txtAssetModelCode->Display = false;
		$this->lstCategory->Display = false;
		$this->lstManufacturer->Display = false;
		$this->txtLongDescription->Display = false;

		// Do not display Cancel and Save buttons
		$this->btnCancel->Display = false;
		$this->btnSave->Display = false;

		// Display Labels/Panels for Viewing mode
		$this->lblShortDescription->Display = true;
		$this->lblAssetModelCode->Display = true;
		$this->lblCategory->Display = true;
		$this->lblManufacturer->Display = true;
		$this->pnlLongDescription->Display = true;

		// Display Depreciation label if option enabled
		if (QApplication::$TracmorSettings->DepreciationFlag == '1'){
			$this->lblDepreciationClass->Display = true;
			$this->lstDepreciationClass->Display = false;
		}

		// Display Edit and Delete buttons
		$this->btnEdit->Display = true;
		$this->btnDelete->Display = true;
		$this->atcAttach->btnUpload->Display = true;
		// $this->btnClone->Display = true;

		// Display custom field labels
		if ($this->arrCustomFields) {
			CustomField::DisplayLabels($this->arrCustomFields);
		}
	}

	// Display the inputs and buttons for Edit or Create mode
	protected function displayInputs() {

		// Do not display labels/panels
		$this->lblShortDescription->Display = false;
		$this->lblAssetModelCode->Display = false;
		$this->lblCategory->Display = false;
		$this->lblManufacturer->Display = false;
		$this->lblImage->Display = false;
		$this->pnlLongDescription->Display = false;

		// Display inputs
		$this->txtShortDescription->Display = true;
		$this->txtAssetModelCode->Display = true;
		$this->lstCategory->Display = true;
		$this->lstManufacturer->Display = true;
		$this->txtLongDescription->Display = true;
		$this->ifcImage->Display = true;

		// Display Depreciation field if enabled
		if (QApplication::$TracmorSettings->DepreciationFlag == '1'){
			$this->lblDepreciationClass->Display = false;
			$this->lstDepreciationClass->Display = true;
		}

		// Display Asset Tag and Asset Model input for edit mode
		// new: if the user is authorized to edit the built-in fields.
		//If the user is not authorized to edit built-in fields, the fields are render as labels.
		if(!$this->blnEditBuiltInFields){
			$this->displayLabels();
		}



		// Do not display Edit and Delete buttons
		$this->btnEdit->Display = false;
		$this->btnDelete->Display = false;
		$this->atcAttach->btnUpload->Display = false;

		// Display Cancel and Save butons
		$this->btnCancel->Display = true;
		$this->btnSave->Display = true;


		// Display custom field inputs
		if ($this->arrCustomFields) {
			CustomField::DisplayInputs($this->arrCustomFields);
		}
	}

	protected function UpdateLabels() {

		$this->lblShortDescription->Text = $this->txtShortDescription->Text;
		$this->lblAssetModelCode->Text = $this->txtAssetModelCode->Text;
		$this->lblCategory->Text = $this->lstCategory->SelectedName;
		$this->lblManufacturer->Text = $this->lstManufacturer->SelectedName;
		$this->pnlLongDescription->Text = nl2br($this->txtLongDescription->Text);
		$this->lblImage->Text = $this->ifcImage->GetDisplayHtml($this->objAssetModel->ImagePath);
		
		// Update Depreciation label if enabled
		if (QApplication::$TracmorSettings->DepreciationFlag == '1') {
			$this->lblDepreciationClass->Text = ($this->lstDepreciationClass->SelectedValue==null) ? '' : $this->lstDepreciationClass->SelectedName;
		}

		// Update custom labels
		if ($this->arrCustomFields) {
			CustomField::UpdateLabels($this->arrCustomFields);
		}

		// From AssetModelEditFormBase, this loads an Asset Model object or creates a new one
		$this->SetupAssetModel();
	}

	protected function getNextTabIndex() {
		return $this->intNextTabIndex++;
	}

	//Set display logic of the BuiltInFields in View Access and Edit Access
	protected function UpdateBuiltInFields() {
		//Set View Display Logic of Built-In Fields
		$objRoleEntityQtypeBuiltInAuthorization= RoleEntityQtypeBuiltInAuthorization::LoadByRoleIdEntityQtypeIdAuthorizationId(QApplication::$objRoleModule->RoleId,EntityQtype::AssetModel,1);
		if($objRoleEntityQtypeBuiltInAuthorization && $objRoleEntityQtypeBuiltInAuthorization->AuthorizedFlag)
		$this->blnViewBuiltInFields=true;
		else
		$this->blnViewBuiltInFields=false;

		//Set Edit Display Logic of Built-In Fields
		$objRoleEntityQtypeBuiltInAuthorization2= RoleEntityQtypeBuiltInAuthorization::LoadByRoleIdEntityQtypeIdAuthorizationId(QApplication::$objRoleModule->RoleId,EntityQtype::AssetModel,2);
		if($objRoleEntityQtypeBuiltInAuthorization2 && $objRoleEntityQtypeBuiltInAuthorization2->AuthorizedFlag){
			$this->blnEditBuiltInFields=true;
		}
		else{
			$this->blnEditBuiltInFields=false;
		}
	}
	//Set display logic for the CustomFields
	protected function UpdateCustomFields(){
		if($this->arrCustomFields)foreach ($this->arrCustomFields as $objCustomField) {
			//Set NextTabIndex only if the custom field is show
			if($objCustomField['input']->TabIndex == 0 && $objCustomField['ViewAuth'] && $objCustomField['ViewAuth']->AuthorizedFlag){
				$objCustomField['input']->TabIndex=$this->GetNextTabIndex();
			}
			//In Create Mode, if the role doesn't have edit access for the custom field and the custom field is required, the field shows as a label with the default value
			if (!$this->blnEditMode && !$objCustomField['blnEdit']){
				$objCustomField['lbl']->Display=true;
				$objCustomField['input']->Display=false;
				if(($objCustomField['blnRequired'])){
					if ($objCustomField['EditAuth']->EntityQtypeCustomField->CustomField->DefaultCustomFieldValue) $objCustomField['lbl']->Text=$objCustomField['EditAuth']->EntityQtypeCustomField->CustomField->DefaultCustomFieldValue->__toString();
				}
			}
		}
	}
  //
  protected function UpdateAssetModelCustomFields(){

    //$arrAssetCustomFieldsToAdd = array();
    // $this->chkAssetCustomFields->SelectedValues;
    // Generate array of Custom Field values for All Asset Models must be presented in all cases
  	/*
    $arrAllAssetModelsFlaggedObjects = EntityQtypeCustomField::LoadArrayByEntityQtypeId(QApplication::Translate(EntityQtype::Asset));
    $arrAllAssetModelsFlag = array();
    foreach ($arrAllAssetModelsFlaggedObjects as $arrAllAssetModelsFlaggedObject){
      if ($arrAllAssetModelsFlaggedObject->CustomField->AllAssetModelsFlag){
        $arrAllAssetModelsFlag[] = $arrAllAssetModelsFlaggedObject->CustomField->CustomFieldId;
      }
    }

     $arrAssetCustomFieldsToAdd = array_merge($this->chkAssetCustomFields->SelectedValues,$arrAllAssetModelsFlag);
    */
     $arrAssetCustomFieldsToAdd = array_unique($this->chkAssetCustomFields->SelectedValues);

    // If new asset model add AssetCustomFields for All together with selected
      if(!$this->blnEditMode){
        foreach($arrAssetCustomFieldsToAdd as $keyAssetCustomField){
          $newAssetCustomField = new AssetCustomFieldAssetModel();
          $newAssetCustomField->CustomFieldId = $keyAssetCustomField;
          $newAssetCustomField->AssetModelId  = $this->objAssetModel->AssetModelId;
          $newAssetCustomField->Save();
        }
      }
      // Delete items if unchecked
      else{
        $currentAssetCustomFields = AssetCustomFieldAssetModel::LoadArrayByAssetModelId($this->objAssetModel->AssetModelId);
        foreach($currentAssetCustomFields as $currentAssetCustomField){
          if (!$currentAssetCustomField->CustomField->AllAssetModelsFlag &&
			  !(in_array($currentAssetCustomField->CustomField->CustomFieldId,$arrAssetCustomFieldsToAdd))){
			// If blnEditMode some Assets for this Model can be already assigned and them values
			// for this custom field must be set to null
			$arrAssetsAssignedToModel = new Asset;
			$arrAssetsAssignedToModel = $arrAssetsAssignedToModel->LoadArrayByAssetModelId(
			                                                       $this->objAssetModel->AssetModelId);
			if(count($arrAssetsAssignedToModel)>0){
		    $arrAssetOfModel = array();
			foreach($arrAssetsAssignedToModel as $objAssetAssignedToModel)  {
				array_push($arrAssetOfModel, $objAssetAssignedToModel->AssetId);
		        }
				$arrAssetOfModel = implode(",",$arrAssetOfModel);
				//print $arrAssetOfModel; exit;
				$objDatabase = CustomField::GetDatabase();
				$strQuery = sprintf("UPDATE `asset_custom_field_helper` SET `cfv_%s`= NULL WHERE `asset_id` IN($arrAssetOfModel);",$currentAssetCustomField->CustomFieldId);
				$objDatabase->NonQuery($strQuery);
            }
			// then Delete Associations
            $currentAssetCustomField->Delete();
          }
        }
        foreach($arrAssetCustomFieldsToAdd as $keyAssetCustomField){
          $blnToAdd = true;
          foreach($currentAssetCustomFields as $currentAssetCustomField){
            if ($currentAssetCustomField->CustomField->CustomFieldId == $arrAssetCustomFieldsToAdd){
              $blnToAdd = false;
            }
          }
          if($blnToAdd){
            $newAssetCustomField = new AssetCustomFieldAssetModel();
            $newAssetCustomField->CustomFieldId = $keyAssetCustomField;
            $newAssetCustomField->AssetModelId  = $this->objAssetModel->AssetModelId;
            $newAssetCustomField->Save();

			// If custom field is required add default value to appropriate Assets
			  $objCustomFieldToAdd = new CustomField;
			  $objCustomFieldToAdd = $objCustomFieldToAdd->Load($keyAssetCustomField);

			  if ($objCustomFieldToAdd->RequiredFlag){
			  $arrAssetsAssignedToModel = new Asset;
			  $arrAssetsAssignedToModel = $arrAssetsAssignedToModel->LoadArrayByAssetModelId(
			 															 $this->objAssetModel->AssetModelId);

			  if(count($arrAssetsAssignedToModel)>0){
				  $txtDefaultValue = CustomFieldValue::LoadByCustomFieldValueId($objCustomFieldToAdd->DefaultCustomFieldValueId);

				  $arrAssetOfModel = array();
				  foreach($arrAssetsAssignedToModel as $objAssetAssignedToModel)  {
					  array_push($arrAssetOfModel, $objAssetAssignedToModel->AssetId);
				  }
				  $arrAssetOfModel = implode(",",$arrAssetOfModel);
				  $objDatabase = CustomField::GetDatabase();
				  $strQuery = sprintf("UPDATE `asset_custom_field_helper` SET `cfv_%s`= %s WHERE `asset_id` IN($arrAssetOfModel);",
					                  $keyAssetCustomField,
									  $txtDefaultValue);
				  $objDatabase->NonQuery($strQuery);
			  }
			  }
			//
          }
        }
      }
  }


}

// Go ahead and run this form object to render the page and its event handlers, using
// generated/asset_model_edit.php.inc as the included HTML template file
AssetModelEditForm::Run('AssetModelEditForm', 'asset_model_edit.tpl.php');
?>
